%------------------------------------------------------------------------------
% File     : LCL949^4 : TPTP v9.2.0. Released v8.1.0.
% Domain   : Logic Calculi
% Problem  : Goedel translation of SET054+1 (from TPTP-v5.0.0)
% Version  : [BP13] axioms.
% English  : 

% Refs     : [RO12]  Raths & Otten (2012), The QMLTP Problem Library for Fi
%          : [BP13]  Benzmueller & Paulson (2013), Quantified Multimodal Lo
%          : [Ste22] Steen (2022), An Extensible Logic Embedding Tool for L
% Source   : [TPTP]
% Names    : GSE054+1 [QMLTP]

% Status   : Theorem 
% Rating   : 0.22 v9.1.0, 0.25 v9.0.0, 0.20 v8.2.0, 0.31 v8.1.0
% Syntax   : Number of formulae    :  141 (  11 unt;  45 typ;  10 def)
%            Number of atoms       : 1245 (  10 equ;   0 cnn)
%            Maximal formula atoms :   32 (  12 avg)
%            Number of connectives : 1970 (   1   ~;   1   |;   3   &;1961   @)
%                                         (   1 <=>;   3  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   27 (  14 avg)
%            Number of types       :    3 (   1 usr)
%            Number of type conns  :  104 ( 104   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   45 (  44 usr;   6 con; 0-3 aty)
%            Number of variables   :  229 ( 221   ^;   6   !;   2   ?; 229   :)
% SPC      : TH0_THM_EQU_NAR

% Comments : This output was generated by embedproblem, version 1.7.1 (library
%            version 1.3). Generated on Thu Apr 28 13:18:18 EDT 2022 using
%            'modal' embedding, version 1.5.2. Logic specification used:
%            $modal == [$constants == $rigid,$quantification == $constant,
%            $modalities == $modal_system_S4].
%------------------------------------------------------------------------------
thf(mworld,type,
    mworld: $tType ).

thf(mrel_type,type,
    mrel: mworld > mworld > $o ).

thf(mactual_type,type,
    mactual: mworld ).

thf(mlocal_type,type,
    mlocal: ( mworld > $o ) > $o ).

thf(mlocal_def,definition,
    ( mlocal
    = ( ^ [Phi: mworld > $o] : ( Phi @ mactual ) ) ) ).

thf(mnot_type,type,
    mnot: ( mworld > $o ) > mworld > $o ).

thf(mand_type,type,
    mand: ( mworld > $o ) > ( mworld > $o ) > mworld > $o ).

thf(mor_type,type,
    mor: ( mworld > $o ) > ( mworld > $o ) > mworld > $o ).

thf(mimplies_type,type,
    mimplies: ( mworld > $o ) > ( mworld > $o ) > mworld > $o ).

thf(mequiv_type,type,
    mequiv: ( mworld > $o ) > ( mworld > $o ) > mworld > $o ).

thf(mnot_def,definition,
    ( mnot
    = ( ^ [A: mworld > $o,W: mworld] :
          ~ ( A @ W ) ) ) ).

thf(mand_def,definition,
    ( mand
    = ( ^ [A: mworld > $o,B: mworld > $o,W: mworld] :
          ( ( A @ W )
          & ( B @ W ) ) ) ) ).

thf(mor_def,definition,
    ( mor
    = ( ^ [A: mworld > $o,B: mworld > $o,W: mworld] :
          ( ( A @ W )
          | ( B @ W ) ) ) ) ).

thf(mimplies_def,definition,
    ( mimplies
    = ( ^ [A: mworld > $o,B: mworld > $o,W: mworld] :
          ( ( A @ W )
         => ( B @ W ) ) ) ) ).

thf(mequiv_def,definition,
    ( mequiv
    = ( ^ [A: mworld > $o,B: mworld > $o,W: mworld] :
          ( ( A @ W )
        <=> ( B @ W ) ) ) ) ).

thf(mbox_type,type,
    mbox: ( mworld > $o ) > mworld > $o ).

thf(mbox_def,definition,
    ( mbox
    = ( ^ [Phi: mworld > $o,W: mworld] :
        ! [V: mworld] :
          ( ( mrel @ W @ V )
         => ( Phi @ V ) ) ) ) ).

thf(mdia_type,type,
    mdia: ( mworld > $o ) > mworld > $o ).

thf(mdia_def,definition,
    ( mdia
    = ( ^ [Phi: mworld > $o,W: mworld] :
        ? [V: mworld] :
          ( ( mrel @ W @ V )
          & ( Phi @ V ) ) ) ) ).

thf(mrel_reflexive,axiom,
    ! [W: mworld] : ( mrel @ W @ W ) ).

thf(mrel_transitive,axiom,
    ! [W: mworld,V: mworld,U: mworld] :
      ( ( ( mrel @ W @ V )
        & ( mrel @ V @ U ) )
     => ( mrel @ W @ U ) ) ).

thf(mforall_di_type,type,
    mforall_di: ( $i > mworld > $o ) > mworld > $o ).

thf(mforall_di_def,definition,
    ( mforall_di
    = ( ^ [A: $i > mworld > $o,W: mworld] :
        ! [X: $i] : ( A @ X @ W ) ) ) ).

thf(mexists_di_type,type,
    mexists_di: ( $i > mworld > $o ) > mworld > $o ).

thf(mexists_di_def,definition,
    ( mexists_di
    = ( ^ [A: $i > mworld > $o,W: mworld] :
        ? [X: $i] : ( A @ X @ W ) ) ) ).

thf(universal_class_decl,type,
    universal_class: $i ).

thf(identity_relation_decl,type,
    identity_relation: $i ).

thf(successor_relation_decl,type,
    successor_relation: $i ).

thf(element_relation_decl,type,
    element_relation: $i ).

thf(null_class_decl,type,
    null_class: $i ).

thf(qmltpeq_decl,type,
    qmltpeq: $i > $i > mworld > $o ).

thf(inductive_decl,type,
    inductive: $i > mworld > $o ).

thf(disjoint_decl,type,
    disjoint: $i > $i > mworld > $o ).

thf(function_decl,type,
    function: $i > mworld > $o ).

thf(member_decl,type,
    member: $i > $i > mworld > $o ).

thf(subclass_decl,type,
    subclass: $i > $i > mworld > $o ).

thf(singleton_decl,type,
    singleton: $i > $i ).

thf(image_decl,type,
    image: $i > $i > $i ).

thf(inverse_decl,type,
    inverse: $i > $i ).

thf(rotate_decl,type,
    rotate: $i > $i ).

thf(unordered_pair_decl,type,
    unordered_pair: $i > $i > $i ).

thf(successor_decl,type,
    successor: $i > $i ).

thf(apply_decl,type,
    apply: $i > $i > $i ).

thf(power_class_decl,type,
    power_class: $i > $i ).

thf(range_of_decl,type,
    range_of: $i > $i ).

thf(union_decl,type,
    union: $i > $i > $i ).

thf(restrict_decl,type,
    restrict: $i > $i > $i > $i ).

thf(second_decl,type,
    second: $i > $i ).

thf(ordered_pair_decl,type,
    ordered_pair: $i > $i > $i ).

thf(domain_of_decl,type,
    domain_of: $i > $i ).

thf(sum_class_decl,type,
    sum_class: $i > $i ).

thf(compose_decl,type,
    compose: $i > $i > $i ).

thf(intersection_decl,type,
    intersection: $i > $i > $i ).

thf(cross_product_decl,type,
    cross_product: $i > $i > $i ).

thf(complement_decl,type,
    complement: $i > $i ).

thf(flip_decl,type,
    flip: $i > $i ).

thf(first_decl,type,
    first: $i > $i ).

thf(reflexivity,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] : ( mbox @ ( qmltpeq @ X @ X ) ) ) ) ) ).

thf(symmetry,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [Y: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ X @ Y ) ) @ ( mbox @ ( qmltpeq @ Y @ X ) ) ) ) ) ) ) ) ) ).

thf(transitivity,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [Y: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [Z: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( qmltpeq @ X @ Y ) ) @ ( mbox @ ( qmltpeq @ Y @ Z ) ) ) @ ( mbox @ ( qmltpeq @ X @ Z ) ) ) ) ) ) ) ) ) ) ) ).

thf(apply_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( qmltpeq @ ( apply @ A @ C ) @ ( apply @ B @ C ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(apply_substitution_2,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( qmltpeq @ ( apply @ C @ A ) @ ( apply @ C @ B ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(complement_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( qmltpeq @ ( complement @ A ) @ ( complement @ B ) ) ) ) ) ) ) ) ) ) ).

thf(compose_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( qmltpeq @ ( compose @ A @ C ) @ ( compose @ B @ C ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(compose_substitution_2,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( qmltpeq @ ( compose @ C @ A ) @ ( compose @ C @ B ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(cross_product_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( qmltpeq @ ( cross_product @ A @ C ) @ ( cross_product @ B @ C ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(cross_product_substitution_2,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( qmltpeq @ ( cross_product @ C @ A ) @ ( cross_product @ C @ B ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(domain_of_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( qmltpeq @ ( domain_of @ A ) @ ( domain_of @ B ) ) ) ) ) ) ) ) ) ) ).

thf(first_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( qmltpeq @ ( first @ A ) @ ( first @ B ) ) ) ) ) ) ) ) ) ) ).

thf(flip_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( qmltpeq @ ( flip @ A ) @ ( flip @ B ) ) ) ) ) ) ) ) ) ) ).

thf(image_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( qmltpeq @ ( image @ A @ C ) @ ( image @ B @ C ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(image_substitution_2,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( qmltpeq @ ( image @ C @ A ) @ ( image @ C @ B ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(intersection_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( qmltpeq @ ( intersection @ A @ C ) @ ( intersection @ B @ C ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(intersection_substitution_2,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( qmltpeq @ ( intersection @ C @ A ) @ ( intersection @ C @ B ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(inverse_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( qmltpeq @ ( inverse @ A ) @ ( inverse @ B ) ) ) ) ) ) ) ) ) ) ).

thf(ordered_pair_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( qmltpeq @ ( ordered_pair @ A @ C ) @ ( ordered_pair @ B @ C ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(ordered_pair_substitution_2,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( qmltpeq @ ( ordered_pair @ C @ A ) @ ( ordered_pair @ C @ B ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(power_class_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( qmltpeq @ ( power_class @ A ) @ ( power_class @ B ) ) ) ) ) ) ) ) ) ) ).

thf(range_of_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( qmltpeq @ ( range_of @ A ) @ ( range_of @ B ) ) ) ) ) ) ) ) ) ) ).

thf(restrict_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] :
                        ( mbox
                        @ ( mforall_di
                          @ ^ [D: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( qmltpeq @ ( restrict @ A @ C @ D ) @ ( restrict @ B @ C @ D ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(restrict_substitution_2,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] :
                        ( mbox
                        @ ( mforall_di
                          @ ^ [D: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( qmltpeq @ ( restrict @ C @ A @ D ) @ ( restrict @ C @ B @ D ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(restrict_substitution_3,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] :
                        ( mbox
                        @ ( mforall_di
                          @ ^ [D: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( qmltpeq @ ( restrict @ C @ D @ A ) @ ( restrict @ C @ D @ B ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(rotate_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( qmltpeq @ ( rotate @ A ) @ ( rotate @ B ) ) ) ) ) ) ) ) ) ) ).

thf(second_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( qmltpeq @ ( second @ A ) @ ( second @ B ) ) ) ) ) ) ) ) ) ) ).

thf(singleton_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( qmltpeq @ ( singleton @ A ) @ ( singleton @ B ) ) ) ) ) ) ) ) ) ) ).

thf(successor_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( qmltpeq @ ( successor @ A ) @ ( successor @ B ) ) ) ) ) ) ) ) ) ) ).

thf(sum_class_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( qmltpeq @ ( sum_class @ A ) @ ( sum_class @ B ) ) ) ) ) ) ) ) ) ) ).

thf(union_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( qmltpeq @ ( union @ A @ C ) @ ( union @ B @ C ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(union_substitution_2,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( qmltpeq @ ( union @ C @ A ) @ ( union @ C @ B ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(unordered_pair_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( qmltpeq @ ( unordered_pair @ A @ C ) @ ( unordered_pair @ B @ C ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(unordered_pair_substitution_2,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( qmltpeq @ ( unordered_pair @ C @ A ) @ ( unordered_pair @ C @ B ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(disjoint_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( disjoint @ A @ C ) ) ) @ ( mbox @ ( disjoint @ B @ C ) ) ) ) ) ) ) ) ) ) ) ).

thf(disjoint_substitution_2,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( disjoint @ C @ A ) ) ) @ ( mbox @ ( disjoint @ C @ B ) ) ) ) ) ) ) ) ) ) ) ).

thf(function_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( function @ A ) ) ) @ ( mbox @ ( function @ B ) ) ) ) ) ) ) ) ) ).

thf(inductive_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( inductive @ A ) ) ) @ ( mbox @ ( inductive @ B ) ) ) ) ) ) ) ) ) ).

thf(member_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( member @ A @ C ) ) ) @ ( mbox @ ( member @ B @ C ) ) ) ) ) ) ) ) ) ) ) ).

thf(member_substitution_2,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( member @ C @ A ) ) ) @ ( mbox @ ( member @ C @ B ) ) ) ) ) ) ) ) ) ) ) ).

thf(subclass_substitution_1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( subclass @ A @ C ) ) ) @ ( mbox @ ( subclass @ B @ C ) ) ) ) ) ) ) ) ) ) ) ).

thf(subclass_substitution_2,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [A: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [B: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [C: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( qmltpeq @ A @ B ) ) @ ( mbox @ ( subclass @ C @ A ) ) ) @ ( mbox @ ( subclass @ C @ B ) ) ) ) ) ) ) ) ) ) ) ).

thf(subclass_defn,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [Y: $i] :
                  ( mand
                  @ ( mbox
                    @ ( mimplies @ ( mbox @ ( subclass @ X @ Y ) )
                      @ ( mbox
                        @ ( mforall_di
                          @ ^ [U: $i] : ( mbox @ ( mimplies @ ( mbox @ ( member @ U @ X ) ) @ ( mbox @ ( member @ U @ Y ) ) ) ) ) ) ) )
                  @ ( mbox
                    @ ( mimplies
                      @ ( mbox
                        @ ( mforall_di
                          @ ^ [U: $i] : ( mbox @ ( mimplies @ ( mbox @ ( member @ U @ X ) ) @ ( mbox @ ( member @ U @ Y ) ) ) ) ) )
                      @ ( mbox @ ( subclass @ X @ Y ) ) ) ) ) ) ) ) ) ) ).

thf(class_elements_are_sets,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] : ( mbox @ ( subclass @ X @ universal_class ) ) ) ) ) ).

thf(extensionality,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [Y: $i] : ( mand @ ( mbox @ ( mimplies @ ( mbox @ ( qmltpeq @ X @ Y ) ) @ ( mand @ ( mbox @ ( subclass @ X @ Y ) ) @ ( mbox @ ( subclass @ Y @ X ) ) ) ) ) @ ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( subclass @ X @ Y ) ) @ ( mbox @ ( subclass @ Y @ X ) ) ) @ ( mbox @ ( qmltpeq @ X @ Y ) ) ) ) ) ) ) ) ) ) ).

thf(unordered_pair_defn,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [U: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [X: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [Y: $i] : ( mand @ ( mbox @ ( mimplies @ ( mbox @ ( member @ U @ ( unordered_pair @ X @ Y ) ) ) @ ( mand @ ( mbox @ ( member @ U @ universal_class ) ) @ ( mor @ ( mbox @ ( qmltpeq @ U @ X ) ) @ ( mbox @ ( qmltpeq @ U @ Y ) ) ) ) ) ) @ ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( member @ U @ universal_class ) ) @ ( mor @ ( mbox @ ( qmltpeq @ U @ X ) ) @ ( mbox @ ( qmltpeq @ U @ Y ) ) ) ) @ ( mbox @ ( member @ U @ ( unordered_pair @ X @ Y ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(unordered_pair_0,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [Y: $i] : ( mbox @ ( member @ ( unordered_pair @ X @ Y ) @ universal_class ) ) ) ) ) ) ) ).

thf(singleton_set_defn,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] : ( mbox @ ( qmltpeq @ ( singleton @ X ) @ ( unordered_pair @ X @ X ) ) ) ) ) ) ).

thf(ordered_pair_defn,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [Y: $i] : ( mbox @ ( qmltpeq @ ( ordered_pair @ X @ Y ) @ ( unordered_pair @ ( singleton @ X ) @ ( unordered_pair @ X @ ( singleton @ Y ) ) ) ) ) ) ) ) ) ) ).

thf(cross_product_defn,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [U: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [V: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [X: $i] :
                        ( mbox
                        @ ( mforall_di
                          @ ^ [Y: $i] : ( mand @ ( mbox @ ( mimplies @ ( mbox @ ( member @ ( ordered_pair @ U @ V ) @ ( cross_product @ X @ Y ) ) ) @ ( mand @ ( mbox @ ( member @ U @ X ) ) @ ( mbox @ ( member @ V @ Y ) ) ) ) ) @ ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( member @ U @ X ) ) @ ( mbox @ ( member @ V @ Y ) ) ) @ ( mbox @ ( member @ ( ordered_pair @ U @ V ) @ ( cross_product @ X @ Y ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(cross_product_0,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [Y: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [Z: $i] : ( mbox @ ( mimplies @ ( mbox @ ( member @ Z @ ( cross_product @ X @ Y ) ) ) @ ( mbox @ ( qmltpeq @ Z @ ( ordered_pair @ ( first @ Z ) @ ( second @ Z ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(element_relation_defn,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [Y: $i] : ( mand @ ( mbox @ ( mimplies @ ( mbox @ ( member @ ( ordered_pair @ X @ Y ) @ element_relation ) ) @ ( mand @ ( mbox @ ( member @ Y @ universal_class ) ) @ ( mbox @ ( member @ X @ Y ) ) ) ) ) @ ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( member @ Y @ universal_class ) ) @ ( mbox @ ( member @ X @ Y ) ) ) @ ( mbox @ ( member @ ( ordered_pair @ X @ Y ) @ element_relation ) ) ) ) ) ) ) ) ) ) ).

thf(element_relation_0,axiom,
    mlocal @ ( mbox @ ( subclass @ element_relation @ ( cross_product @ universal_class @ universal_class ) ) ) ).

thf(intersection_0,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [Y: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [Z: $i] : ( mand @ ( mbox @ ( mimplies @ ( mbox @ ( member @ Z @ ( intersection @ X @ Y ) ) ) @ ( mand @ ( mbox @ ( member @ Z @ X ) ) @ ( mbox @ ( member @ Z @ Y ) ) ) ) ) @ ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( member @ Z @ X ) ) @ ( mbox @ ( member @ Z @ Y ) ) ) @ ( mbox @ ( member @ Z @ ( intersection @ X @ Y ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(complement_0,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [Z: $i] : ( mand @ ( mbox @ ( mimplies @ ( mbox @ ( member @ Z @ ( complement @ X ) ) ) @ ( mand @ ( mbox @ ( member @ Z @ universal_class ) ) @ ( mbox @ ( mnot @ ( mbox @ ( member @ Z @ X ) ) ) ) ) ) ) @ ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( member @ Z @ universal_class ) ) @ ( mbox @ ( mnot @ ( mbox @ ( member @ Z @ X ) ) ) ) ) @ ( mbox @ ( member @ Z @ ( complement @ X ) ) ) ) ) ) ) ) ) ) ) ).

thf(restrict_defn,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [XR: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [Y: $i] : ( mbox @ ( qmltpeq @ ( restrict @ XR @ X @ Y ) @ ( intersection @ XR @ ( cross_product @ X @ Y ) ) ) ) ) ) ) ) ) ) ) ).

thf(null_class_defn,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] : ( mbox @ ( mnot @ ( mbox @ ( member @ X @ null_class ) ) ) ) ) ) ) ).

thf(domain_of_0,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [Z: $i] : ( mand @ ( mbox @ ( mimplies @ ( mbox @ ( member @ Z @ ( domain_of @ X ) ) ) @ ( mand @ ( mbox @ ( member @ Z @ universal_class ) ) @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ ( restrict @ X @ ( singleton @ Z ) @ universal_class ) @ null_class ) ) ) ) ) ) ) @ ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( member @ Z @ universal_class ) ) @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ ( restrict @ X @ ( singleton @ Z ) @ universal_class ) @ null_class ) ) ) ) ) @ ( mbox @ ( member @ Z @ ( domain_of @ X ) ) ) ) ) ) ) ) ) ) ) ).

thf(rotate_defn,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [U: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [V: $i] :
                        ( mbox
                        @ ( mforall_di
                          @ ^ [W: $i] : ( mand @ ( mbox @ ( mimplies @ ( mbox @ ( member @ ( ordered_pair @ ( ordered_pair @ U @ V ) @ W ) @ ( rotate @ X ) ) ) @ ( mand @ ( mbox @ ( member @ ( ordered_pair @ ( ordered_pair @ U @ V ) @ W ) @ ( cross_product @ ( cross_product @ universal_class @ universal_class ) @ universal_class ) ) ) @ ( mbox @ ( member @ ( ordered_pair @ ( ordered_pair @ V @ W ) @ U ) @ X ) ) ) ) ) @ ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( member @ ( ordered_pair @ ( ordered_pair @ U @ V ) @ W ) @ ( cross_product @ ( cross_product @ universal_class @ universal_class ) @ universal_class ) ) ) @ ( mbox @ ( member @ ( ordered_pair @ ( ordered_pair @ V @ W ) @ U ) @ X ) ) ) @ ( mbox @ ( member @ ( ordered_pair @ ( ordered_pair @ U @ V ) @ W ) @ ( rotate @ X ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(rotate_0,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] : ( mbox @ ( subclass @ ( rotate @ X ) @ ( cross_product @ ( cross_product @ universal_class @ universal_class ) @ universal_class ) ) ) ) ) ) ).

thf(flip_defn,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [U: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [V: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [W: $i] :
                        ( mbox
                        @ ( mforall_di
                          @ ^ [X: $i] : ( mand @ ( mbox @ ( mimplies @ ( mbox @ ( member @ ( ordered_pair @ ( ordered_pair @ U @ V ) @ W ) @ ( flip @ X ) ) ) @ ( mand @ ( mbox @ ( member @ ( ordered_pair @ ( ordered_pair @ U @ V ) @ W ) @ ( cross_product @ ( cross_product @ universal_class @ universal_class ) @ universal_class ) ) ) @ ( mbox @ ( member @ ( ordered_pair @ ( ordered_pair @ V @ U ) @ W ) @ X ) ) ) ) ) @ ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( member @ ( ordered_pair @ ( ordered_pair @ U @ V ) @ W ) @ ( cross_product @ ( cross_product @ universal_class @ universal_class ) @ universal_class ) ) ) @ ( mbox @ ( member @ ( ordered_pair @ ( ordered_pair @ V @ U ) @ W ) @ X ) ) ) @ ( mbox @ ( member @ ( ordered_pair @ ( ordered_pair @ U @ V ) @ W ) @ ( flip @ X ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(flip_0,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] : ( mbox @ ( subclass @ ( flip @ X ) @ ( cross_product @ ( cross_product @ universal_class @ universal_class ) @ universal_class ) ) ) ) ) ) ).

thf(union_defn,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [Y: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [Z: $i] : ( mand @ ( mbox @ ( mimplies @ ( mbox @ ( member @ Z @ ( union @ X @ Y ) ) ) @ ( mor @ ( mbox @ ( member @ Z @ X ) ) @ ( mbox @ ( member @ Z @ Y ) ) ) ) ) @ ( mbox @ ( mimplies @ ( mor @ ( mbox @ ( member @ Z @ X ) ) @ ( mbox @ ( member @ Z @ Y ) ) ) @ ( mbox @ ( member @ Z @ ( union @ X @ Y ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(successor_defn,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] : ( mbox @ ( qmltpeq @ ( successor @ X ) @ ( union @ X @ ( singleton @ X ) ) ) ) ) ) ) ).

thf(successor_relation_defn1,axiom,
    mlocal @ ( mbox @ ( subclass @ successor_relation @ ( cross_product @ universal_class @ universal_class ) ) ) ).

thf(successor_relation_defn2,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [Y: $i] : ( mand @ ( mbox @ ( mimplies @ ( mbox @ ( member @ ( ordered_pair @ X @ Y ) @ successor_relation ) ) @ ( mand @ ( mbox @ ( member @ X @ universal_class ) ) @ ( mand @ ( mbox @ ( member @ Y @ universal_class ) ) @ ( mbox @ ( qmltpeq @ ( successor @ X ) @ Y ) ) ) ) ) ) @ ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( member @ X @ universal_class ) ) @ ( mand @ ( mbox @ ( member @ Y @ universal_class ) ) @ ( mbox @ ( qmltpeq @ ( successor @ X ) @ Y ) ) ) ) @ ( mbox @ ( member @ ( ordered_pair @ X @ Y ) @ successor_relation ) ) ) ) ) ) ) ) ) ) ).

thf(inverse_defn,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [Y: $i] : ( mbox @ ( qmltpeq @ ( inverse @ Y ) @ ( domain_of @ ( flip @ ( cross_product @ Y @ universal_class ) ) ) ) ) ) ) ) ).

thf(range_of_defn,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [Z: $i] : ( mbox @ ( qmltpeq @ ( range_of @ Z ) @ ( domain_of @ ( inverse @ Z ) ) ) ) ) ) ) ).

thf(image_defn,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [XR: $i] : ( mbox @ ( qmltpeq @ ( image @ XR @ X ) @ ( range_of @ ( restrict @ XR @ X @ universal_class ) ) ) ) ) ) ) ) ) ).

thf(inductive_defn,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] : ( mand @ ( mbox @ ( mimplies @ ( mbox @ ( inductive @ X ) ) @ ( mand @ ( mbox @ ( member @ null_class @ X ) ) @ ( mbox @ ( subclass @ ( image @ successor_relation @ X ) @ X ) ) ) ) ) @ ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( member @ null_class @ X ) ) @ ( mbox @ ( subclass @ ( image @ successor_relation @ X ) @ X ) ) ) @ ( mbox @ ( inductive @ X ) ) ) ) ) ) ) ) ).

thf(infinity,axiom,
    ( mlocal
    @ ( mexists_di
      @ ^ [X: $i] :
          ( mand @ ( mbox @ ( member @ X @ universal_class ) )
          @ ( mand @ ( mbox @ ( inductive @ X ) )
            @ ( mbox
              @ ( mforall_di
                @ ^ [Y: $i] : ( mbox @ ( mimplies @ ( mbox @ ( inductive @ Y ) ) @ ( mbox @ ( subclass @ X @ Y ) ) ) ) ) ) ) ) ) ) ).

thf(sum_class_defn,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [U: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [X: $i] :
                  ( mand
                  @ ( mbox
                    @ ( mimplies @ ( mbox @ ( member @ U @ ( sum_class @ X ) ) )
                      @ ( mexists_di
                        @ ^ [Y: $i] : ( mand @ ( mbox @ ( member @ U @ Y ) ) @ ( mbox @ ( member @ Y @ X ) ) ) ) ) )
                  @ ( mbox
                    @ ( mimplies
                      @ ( mexists_di
                        @ ^ [Y: $i] : ( mand @ ( mbox @ ( member @ U @ Y ) ) @ ( mbox @ ( member @ Y @ X ) ) ) )
                      @ ( mbox @ ( member @ U @ ( sum_class @ X ) ) ) ) ) ) ) ) ) ) ) ).

thf(sum_class_0,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] : ( mbox @ ( mimplies @ ( mbox @ ( member @ X @ universal_class ) ) @ ( mbox @ ( member @ ( sum_class @ X ) @ universal_class ) ) ) ) ) ) ) ).

thf(power_class_defn,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [U: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [X: $i] : ( mand @ ( mbox @ ( mimplies @ ( mbox @ ( member @ U @ ( power_class @ X ) ) ) @ ( mand @ ( mbox @ ( member @ U @ universal_class ) ) @ ( mbox @ ( subclass @ U @ X ) ) ) ) ) @ ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( member @ U @ universal_class ) ) @ ( mbox @ ( subclass @ U @ X ) ) ) @ ( mbox @ ( member @ U @ ( power_class @ X ) ) ) ) ) ) ) ) ) ) ) ).

thf(power_class_0,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [U: $i] : ( mbox @ ( mimplies @ ( mbox @ ( member @ U @ universal_class ) ) @ ( mbox @ ( member @ ( power_class @ U ) @ universal_class ) ) ) ) ) ) ) ).

thf(compose_defn1,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [XR: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [YR: $i] : ( mbox @ ( subclass @ ( compose @ YR @ XR ) @ ( cross_product @ universal_class @ universal_class ) ) ) ) ) ) ) ) ).

thf(compose_defn2,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [XR: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [YR: $i] :
                  ( mbox
                  @ ( mforall_di
                    @ ^ [U: $i] :
                        ( mbox
                        @ ( mforall_di
                          @ ^ [V: $i] : ( mand @ ( mbox @ ( mimplies @ ( mbox @ ( member @ ( ordered_pair @ U @ V ) @ ( compose @ YR @ XR ) ) ) @ ( mand @ ( mbox @ ( member @ U @ universal_class ) ) @ ( mbox @ ( member @ V @ ( image @ YR @ ( image @ YR @ ( singleton @ U ) ) ) ) ) ) ) ) @ ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( member @ U @ universal_class ) ) @ ( mbox @ ( member @ V @ ( image @ YR @ ( image @ YR @ ( singleton @ U ) ) ) ) ) ) @ ( mbox @ ( member @ ( ordered_pair @ U @ V ) @ ( compose @ YR @ XR ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ).

thf(function_defn,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [XF: $i] : ( mand @ ( mbox @ ( mimplies @ ( mbox @ ( function @ XF ) ) @ ( mand @ ( mbox @ ( subclass @ XF @ ( cross_product @ universal_class @ universal_class ) ) ) @ ( mbox @ ( subclass @ ( compose @ XF @ ( inverse @ XF ) ) @ identity_relation ) ) ) ) ) @ ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( subclass @ XF @ ( cross_product @ universal_class @ universal_class ) ) ) @ ( mbox @ ( subclass @ ( compose @ XF @ ( inverse @ XF ) ) @ identity_relation ) ) ) @ ( mbox @ ( function @ XF ) ) ) ) ) ) ) ) ).

thf(replacement,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [XF: $i] : ( mbox @ ( mimplies @ ( mand @ ( mbox @ ( member @ X @ universal_class ) ) @ ( mbox @ ( function @ XF ) ) ) @ ( mbox @ ( member @ ( image @ XF @ X ) @ universal_class ) ) ) ) ) ) ) ) ) ).

thf(disjoint_defn,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [Y: $i] :
                  ( mand
                  @ ( mbox
                    @ ( mimplies @ ( mbox @ ( disjoint @ X @ Y ) )
                      @ ( mbox
                        @ ( mforall_di
                          @ ^ [U: $i] : ( mbox @ ( mnot @ ( mand @ ( mbox @ ( member @ U @ X ) ) @ ( mbox @ ( member @ U @ Y ) ) ) ) ) ) ) ) )
                  @ ( mbox
                    @ ( mimplies
                      @ ( mbox
                        @ ( mforall_di
                          @ ^ [U: $i] : ( mbox @ ( mnot @ ( mand @ ( mbox @ ( member @ U @ X ) ) @ ( mbox @ ( member @ U @ Y ) ) ) ) ) ) )
                      @ ( mbox @ ( disjoint @ X @ Y ) ) ) ) ) ) ) ) ) ) ).

thf(regularity,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] :
            ( mbox
            @ ( mimplies @ ( mbox @ ( mnot @ ( mbox @ ( qmltpeq @ X @ null_class ) ) ) )
              @ ( mexists_di
                @ ^ [U: $i] : ( mand @ ( mbox @ ( member @ U @ universal_class ) ) @ ( mand @ ( mbox @ ( member @ U @ X ) ) @ ( mbox @ ( disjoint @ U @ X ) ) ) ) ) ) ) ) ) ) ).

thf(apply_defn,axiom,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [XF: $i] :
            ( mbox
            @ ( mforall_di
              @ ^ [Y: $i] : ( mbox @ ( qmltpeq @ ( apply @ XF @ Y ) @ ( sum_class @ ( image @ XF @ ( singleton @ Y ) ) ) ) ) ) ) ) ) ) ).

thf(choice,axiom,
    ( mlocal
    @ ( mexists_di
      @ ^ [XF: $i] :
          ( mand @ ( mbox @ ( function @ XF ) )
          @ ( mbox
            @ ( mforall_di
              @ ^ [Y: $i] : ( mbox @ ( mimplies @ ( mbox @ ( member @ Y @ universal_class ) ) @ ( mor @ ( mbox @ ( qmltpeq @ Y @ null_class ) ) @ ( mbox @ ( member @ ( apply @ XF @ Y ) @ Y ) ) ) ) ) ) ) ) ) ) ).

thf(reflexivity_of_subclass,conjecture,
    ( mlocal
    @ ( mbox
      @ ( mforall_di
        @ ^ [X: $i] : ( mbox @ ( subclass @ X @ X ) ) ) ) ) ).

%------------------------------------------------------------------------------
